
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Cost")

# Create variables
lemons = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
chicken_thighs = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")

# Set objective function
model.setObjective(1.87 * lemons + 1.19 * chicken_thighs, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * lemons + 9 * chicken_thighs >= 9, "sourness_min")
model.addConstr(4 * lemons + 13 * chicken_thighs >= 16, "healthiness_min")
model.addConstr(-9 * lemons + 2 * chicken_thighs >= 0, "lemon_chicken_ratio")
model.addConstr(5 * lemons + 9 * chicken_thighs <= 20, "sourness_max")
model.addConstr(4 * lemons + 13 * chicken_thighs <= 67, "healthiness_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Lemons: {lemons.x}")
    print(f"  Chicken Thighs: {chicken_thighs.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

