
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables to the model
x1 = model.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="lemons")
x2 = model.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="chicken_thighs")

# Set the objective function
model.setObjective(1.87*x1 + 1.19*x2, GRB.MINIMIZE)

# Add constraints to the model
model.addConstr(5*x1 + 9*x2 >= 9, "Total_Sourness_Index_At_Least_9")
model.addConstr(5*x1 + 9*x2 <= 20, "Total_Sourness_Index_No_More_Than_20")
model.addConstr(4*x1 + 13*x2 >= 16, "Total_Healthiness_Rating_At_Least_16")
model.addConstr(4*x1 + 13*x2 <= 67, "Total_Healthiness_Rating_No_More_Than_67")
model.addConstr(-9*x1 + 2*x2 >= 0, "Linear_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {model.objVal}")
    print(f"Lemons: {x1.x}, Chicken Thighs: {x2.x}")
else:
    print("No optimal solution found")
