
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="lemons", lb=0)  # Assuming non-negative for practical purposes
    x2 = model.addVar(name="chicken thighs", lb=0)  # Assuming non-negative for practical purposes

    # Define the objective function
    model.setObjective(1.87 * x1 + 1.19 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + 9 * x2 >= 9, name="sourness_index_constraint")
    model.addConstr(4 * x1 + 13 * x2 >= 16, name="healthiness_rating_constraint")
    model.addConstr(-9 * x1 + 2 * x2 >= 0, name="healthiness_sourness_tradeoff_constraint")
    model.addConstr(5 * x1 + 9 * x2 <= 20, name="max_sourness_index_constraint")
    model.addConstr(4 * x1 + 13 * x2 <= 67, name="max_healthiness_rating_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Lemons: {x1.varValue}")
        print(f"Chicken thighs: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
