
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    bandwidth = m.addVar(vtype=gp.GRB.INTEGER, name="bandwidth")


    # Set objective function
    m.setObjective(9.29 * pen_testers + 9.26 * bandwidth, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * pen_testers + 8 * bandwidth >= 41, "data_accessibility_min")
    m.addConstr(1 * pen_testers + 11 * bandwidth >= 38, "data_integrity_min")
    m.addConstr(6 * pen_testers + 10 * bandwidth >= 21, "cost_min")
    m.addConstr(4 * pen_testers - bandwidth >= 0, "pen_testers_bandwidth_relation")
    m.addConstr(3 * pen_testers + 8 * bandwidth <= 81, "data_accessibility_max")
    m.addConstr(1 * pen_testers + 11 * bandwidth <= 68, "data_integrity_max")
    m.addConstr(6 * pen_testers + 10 * bandwidth <= 54, "cost_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('pen_testers: %g' % pen_testers.x)
        print('bandwidth: %g' % bandwidth.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
