
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
x2 = m.addVar(vtype=GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")

# Set the objective function
m.setObjective(9.29*x1 + 9.26*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 8*x2 >= 41, "data_accessibility_impact")
m.addConstr(1*x1 + 11*x2 >= 38, "data_integrity_impact")
m.addConstr(6*x1 + 10*x2 >= 21, "total_cost_min")
m.addConstr(4*x1 - x2 >= 0, "linear_constraint")
m.addConstr(3*x1 + 8*x2 <= 81, "max_data_accessibility_impact")
m.addConstr(1*x1 + 11*x2 <= 68, "max_data_integrity_impact")
m.addConstr(6*x1 + 10*x2 <= 54, "max_total_cost")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pen Testers: {x1.x}")
    print(f"Mbps Bandwidth Allocated to Monitoring: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
