
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="mbps_bandwidth", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9.29 * x1 + 9.26 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 8 * x2 >= 41, name="data_accessibility_impact")
    model.addConstr(x1 + 11 * x2 >= 38, name="data_integrity_impact")
    model.addConstr(6 * x1 + 10 * x2 >= 21, name="cost")
    model.addConstr(4 * x1 - x2 >= 0, name="relationship")
    model.addConstr(3 * x1 + 8 * x2 <= 81, name="data_accessibility_upper_bound")
    model.addConstr(x1 + 11 * x2 <= 68, name="data_integrity_upper_bound")
    model.addConstr(6 * x1 + 10 * x2 <= 54, name="cost_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Pen testers: {x1.varValue}")
        print(f"Mbps bandwidth allocated to monitoring: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
