
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Organization Score Optimization")

# Create variables
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo")
peggy = m.addVar(lb=0, vtype=GRB.INTEGER, name="peggy")
george = m.addVar(lb=0, vtype=GRB.INTEGER, name="george")
bobby = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby")


# Set objective function
m.setObjective(4 * ringo + 1 * peggy + 1 * george + 6 * bobby, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13 * ringo + 19 * bobby >= 28, "c1")
m.addConstr(2 * peggy + 19 * bobby >= 48, "c2")
m.addConstr(12 * george + 19 * bobby <= 93, "c3")
m.addConstr(2 * peggy + 19 * bobby <= 214, "c4")
m.addConstr(13 * ringo + 2 * peggy + 12 * george + 19 * bobby <= 214, "c5")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Ringo: {ringo.x}")
    print(f"Peggy: {peggy.x}")
    print(f"George: {george.x}")
    print(f"Bobby: {bobby.x}")
    print(f"Objective Value: {m.objVal}")

