
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours_worked_by_Peggy")
x3 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours_worked_by_George")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Define the objective function
m.setObjective(4*x1 + x2 + x3 + 6*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x1 + 19*x4 >= 28, "Ringo_and_Bobby_min")
m.addConstr(2*x2 + 19*x4 >= 48, "Peggy_and_Bobby_min")
m.addConstr(12*x3 + 19*x4 <= 93, "George_and_Bobby_max")
m.addConstr(2*x2 + 19*x4 <= 214, "Peggy_and_Bobby_max")
m.addConstr(13*x1 + 2*x2 + 12*x3 + 19*x4 <= 299, "Total_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by Peggy: {x2.x}")
    print(f"Hours worked by George: {x3.x}")
    print(f"Hours worked by Bobby: {x4.x}")
else:
    print("No optimal solution found")
