
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x1 = m.addVar(lb=1, ub=1, name="Ringo")  # fixed at 1
x2 = m.addVar(lb=1, ub=1, vtype=gurobi.GRB.INTEGER, name="Peggy")  # fixed at 1
x3 = m.addVar(lb=1, ub=1, vtype=gurobi.GRB.INTEGER, name="George")  # fixed at 1
x4 = m.addVar(lb=46/19, ub=81/19, name="Bobby")

# Objective function
m.setObjective(4*x1 + x2 + x3 + 6*x4, gurobi.GRB.MAXIMIZE)

# Solve the problem
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ringo: ", x1.varValue)
    print("Peggy: ", x2.varValue)
    print("George: ", x3.varValue)
    print("Bobby: ", x4.varValue)
else:
    print("The problem is infeasible")
