
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    peggy = model.addVar(vtype=GRB.INTEGER, name="peggy")
    dale = model.addVar(vtype=GRB.INTEGER, name="dale")
    bill = model.addVar(vtype=GRB.CONTINUOUS, name="bill")
    mary = model.addVar(vtype=GRB.CONTINUOUS, name="mary")
    bobby = model.addVar(vtype=GRB.CONTINUOUS, name="bobby")

    # Set objective function
    model.setObjective(7.48 * peggy + 6.82 * dale + 4.25 * bill + 2.38 * mary + 7.91 * bobby, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14 * dale + 5 * mary >= 33, "c0")
    model.addConstr(11 * bill + 12 * bobby >= 31, "c1")
    model.addConstr(2 * peggy + 14 * dale >= 44, "c2")
    model.addConstr(14 * dale + 11 * bill >= 24, "c3")
    model.addConstr(14 * dale + 12 * bobby >= 33, "c4")
    model.addConstr(5 * mary + 12 * bobby >= 20, "c5")
    model.addConstr(2 * peggy + 12 * bobby >= 38, "c6")
    model.addConstr(11 * bill + 5 * mary >= 22, "c7")
    model.addConstr(14 * dale + 5 * mary <= 231, "c8")
    model.addConstr(14 * dale + 11 * bill <= 178, "c9")
    model.addConstr(2 * peggy + 11 * bill <= 232, "c10")
    model.addConstr(14 * dale + 11 * bill + 12 * bobby <= 133, "c11")
    model.addConstr(2 * peggy + 14 * dale + 11 * bill + 5 * mary + 12 * bobby <= 133, "c12")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
