
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
x2 = m.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
x3 = m.addVar(name='x3')  # hours worked by Bill
x4 = m.addVar(name='x4')  # hours worked by Mary
x5 = m.addVar(name='x5')  # hours worked by Bobby

# Define the objective function
m.setObjective(7.48 * x1 + 6.82 * x2 + 4.25 * x3 + 2.38 * x4 + 7.91 * x5, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x2 + 5 * x4 >= 33)
m.addConstr(11 * x3 + 12 * x5 >= 31)
m.addConstr(2 * x1 + 14 * x2 >= 44)
m.addConstr(14 * x2 + 11 * x3 >= 24)
m.addConstr(14 * x2 + 12 * x5 >= 33)
m.addConstr(5 * x4 + 12 * x5 >= 20)
m.addConstr(2 * x1 + 12 * x5 >= 38)
m.addConstr(11 * x3 + 5 * x4 >= 22)
m.addConstr(14 * x2 + 5 * x4 <= 231)
m.addConstr(14 * x2 + 11 * x3 <= 178)
m.addConstr(2 * x1 + 11 * x3 <= 232)
m.addConstr(14 * x2 + 11 * x3 + 12 * x5 <= 133)
m.addConstr(2 * x1 + 14 * x2 + 11 * x3 + 5 * x4 + 12 * x5 <= 133)

# Set bounds for variables (not necessary in this case but can be useful)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x4 >= 0)
m.addConstr(x5 >= 0)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Peggy: ', x1.varValue)
    print('Hours worked by Dale: ', x2.varValue)
    print('Hours worked by Bill: ', x3.varValue)
    print('Hours worked by Mary: ', x4.varValue)
    print('Hours worked by Bobby: ', x5.varValue)
else:
    print('The model is infeasible')
