
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
jean = model.addVar(vtype=gp.GRB.INTEGER, name="jean")
laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")
ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
dale = model.addVar(vtype=gp.GRB.INTEGER, name="dale")


# Set objective function
model.setObjective(9.23 * jean + 5.09 * laura + 8.47 * ringo + 4.47 * paul + 2.96 * dale, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * jean + 29 * laura >= 50)
model.addConstr(20 * jean + 27 * ringo >= 37)
model.addConstr(27 * ringo + 19 * paul >= 53)
model.addConstr(29 * laura + 27 * ringo >= 25)
model.addConstr(20 * jean + 27 * ringo + 3 * dale >= 40)

model.addConstr(22 * ringo + 25 * paul + 21 * dale >= 50)
model.addConstr(22 * jean + 2 * laura + 21 * dale >= 50)
model.addConstr(2 * laura + 22 * ringo + 21 * dale >= 50)
model.addConstr(2 * laura + 22 * ringo + 25 * paul >= 50)

model.addConstr(22 * ringo + 25 * paul + 21 * dale >= 88)
model.addConstr(22 * jean + 2 * laura + 21 * dale >= 88)
model.addConstr(2 * laura + 22 * ringo + 21 * dale >= 88)
model.addConstr(2 * laura + 22 * ringo + 25 * paul >= 88)

model.addConstr(22 * ringo + 25 * paul + 21 * dale >= 73)
model.addConstr(22 * jean + 2 * laura + 21 * dale >= 73)
model.addConstr(2 * laura + 22 * ringo + 21 * dale >= 73)
model.addConstr(2 * laura + 22 * ringo + 25 * paul >= 73)

model.addConstr(22 * ringo + 25 * paul + 21 * dale >= 57)
model.addConstr(22 * jean + 2 * laura + 21 * dale >= 57)
model.addConstr(2 * laura + 22 * ringo + 21 * dale >= 57)
model.addConstr(2 * laura + 22 * ringo + 25 * paul >= 57)


model.addConstr(18 * laura + 12 * paul >= 105)
model.addConstr(3 * laura - 8 * ringo >= 0)

model.addConstr(27 * ringo + 3 * dale <= 145)
model.addConstr(29 * laura + 19 * paul <= 282)
model.addConstr(27 * ringo + 19 * paul <= 180)
model.addConstr(20 * jean + 3 * dale <= 202)
model.addConstr(20 * jean + 27 * ringo + 3 * dale <= 153)
model.addConstr(20 * jean + 29 * laura + 3 * dale <= 215)
model.addConstr(20 * jean + 19 * paul + 3 * dale <= 123)
model.addConstr(20 * jean + 29 * laura + 19 * paul <= 87)
model.addConstr(29 * laura + 27 * ringo + 3 * dale <= 173)
model.addConstr(20 * jean + 29 * laura + 27 * ringo + 19 * paul + 3 * dale <= 173)

model.addConstr(22 * jean + 2 * laura <= 390)
model.addConstr(2 * laura + 25 * paul <= 485)
model.addConstr(22 * jean + 2 * laura + 22 * ringo + 25 * paul + 21 * dale <= 485)

model.addConstr(15 * jean + 27 * dale <= 165)
model.addConstr(15 * jean + 12 * paul <= 244)
model.addConstr(12 * paul + 27 * dale <= 159)
model.addConstr(28 * ringo + 12 * paul <= 575)
model.addConstr(15 * jean + 28 * ringo <= 460)
model.addConstr(28 * ringo + 27 * dale <= 128)
model.addConstr(15 * jean + 18 * laura <= 339)
model.addConstr(18 * laura + 28 * ringo <= 403)
model.addConstr(18 * laura + 12 * paul <= 320)
model.addConstr(15 * jean + 12 * paul + 27 * dale <= 541)
model.addConstr(15 * jean + 28 * ringo + 12 * paul <= 321)
model.addConstr(15 * jean + 18 * laura + 28 * ringo <= 563)
model.addConstr(15 * jean + 18 * laura + 12 * paul <= 396)
model.addConstr(15 * jean + 28 * ringo + 27 * dale <= 485)
model.addConstr(18 * laura + 28 * ringo + 12 * paul <= 229)
model.addConstr(15 * jean + 18 * laura + 28 * ringo + 12 * paul + 27 * dale <= 229)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Jean: {jean.x}")
    print(f"Laura: {laura.x}")
    print(f"Ringo: {ringo.x}")
    print(f"Paul: {paul.x}")
    print(f"Dale: {dale.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

