
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(5*x0 + 4*x1 + 4*x2 + 1*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x0 + 4*x1 + 4*x2 + 12*x3 <= 148)
m.addConstr(12*x0 + 7*x1 + 9*x2 + 1*x3 <= 124)
m.addConstr(4*x0 + 7*x1 + 12*x2 + 6*x3 <= 221)
m.addConstr(x0 + 12*x3 >= 27)
m.addConstr(x0 + 4*x1 >= 13)
m.addConstr(4*x1 + 4*x2 >= 30)
m.addConstr(4*x2 + 12*x3 >= 26)
m.addConstr(x0 + 4*x2 >= 25)
m.addConstr(4*x1 + 4*x2 + 12*x3 >= 21)
m.addConstr(x0 + 4*x1 + 12*x3 >= 21)
m.addConstr(4*x1 + 4*x2 + 12*x3 >= 28)
m.addConstr(x0 + 4*x1 + 12*x3 >= 28)
m.addConstr(12*x0 + 7*x1 + 9*x2 >= 18)
m.addConstr(12*x0 + 9*x2 + x3 >= 18)
m.addConstr(12*x0 + 7*x1 + 9*x2 >= 26)
m.addConstr(12*x0 + 9*x2 + x3 >= 26)
m.addConstr(12*x2 + 6*x3 >= 43)
m.addConstr(4*x0 + 6*x3 >= 31)
m.addConstr(4*x0 + 7*x1 + 6*x3 >= 42)
m.addConstr(7*x1 + 12*x2 + 6*x3 >= 42)
m.addConstr(4*x0 + 7*x1 + 12*x2 >= 42)
m.addConstr(4*x0 + 12*x2 + 6*x3 >= 42)
m.addConstr(4*x0 + 7*x1 + 6*x3 >= 27)
m.addConstr(7*x1 + 12*x2 + 6*x3 >= 27)
m.addConstr(4*x0 + 7*x1 + 12*x2 >= 27)
m.addConstr(4*x0 + 12*x2 + 6*x3 >= 27)
m.addConstr(4*x0 + 7*x1 + 6*x3 >= 33)
m.addConstr(7*x1 + 12*x2 + 6*x3 >= 33)
m.addConstr(4*x0 + 7*x1 + 12*x2 >= 33)
m.addConstr(4*x0 + 12*x2 + 6*x3 >= 33)
m.addConstr(4*x0 + 7*x1 + 6*x3 >= 50)
m.addConstr(7*x1 + 12*x2 + 6*x3 >= 50)
m.addConstr(4*x0 + 7*x1 + 12*x2 >= 50)
m.addConstr(4*x0 + 12*x2 + 6*x3 >= 50)
m.addConstr(x0 + 4*x1 <= 44)
m.addConstr(x0 + 12*x3 <= 47)
m.addConstr(x0 + 4*x1 + 12*x3 <= 102)
m.addConstr(x0 + 4*x1 + 4*x2 + 12*x3 <= 102)
m.addConstr(12*x0 + 9*x2 <= 91)
m.addConstr(7*x1 + x3 <= 50)
m.addConstr(9*x2 + x3 <= 39)
m.addConstr(12*x0 + 7*x1 + x3 <= 69)
m.addConstr(12*x0 + 7*x1 + 9*x2 + x3 <= 69)
m.addConstr(4*x0 + 7*x1 <= 221)
m.addConstr(7*x1 + 6*x3 <= 204)
m.addConstr(12*x2 + 6*x3 <= 142)
m.addConstr(4*x0 + 12*x2 <= 152)
m.addConstr(4*x0 + 7*x1 + 12*x2 + 6*x3 <= 152)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

