
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="diapers", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="candles", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="dish_soap_bottles", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="toilet_paper_rolls", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="bottles_of_ibuprofen", vtype=gp.GRB.INTEGER)
x6 = m.addVar(name="lightbulbs", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(4.26*x1**2 + 7.52*x1*x2 + 6.06*x1*x3 + 4.09*x1*x4 + 8.12*x1*x5 + 9.52*x1*x6 + 
               7.33*x2**2 + 8.57*x2*x3 + 9.7*x2*x6 + 3.01*x3*x4 + 4.79*x3*x5 + 9.61*x3*x6 + 
               1.27*x4**2 + 7.36*x4*x5 + 7.31*x4*x6 + 4.54*x5*x6 + 6.62*x6**2 + 
               1.14*x1 + 1.03*x2 + 9.41*x3 + 4.04*x4 + 3.95*x5 + 4.14*x6, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15*x4 + 28*x6 >= 29)
m.addConstr(18*x1 + 4*x3 >= 38)
m.addConstr(31*x2 + 15*x4 >= 60)
m.addConstr(18*x1 + 8*x5 >= 57)
m.addConstr(18*x1 + 15*x4 >= 37)
m.addConstr(31*x2 + 8*x5 >= 40)
m.addConstr(18**2*x1**2 + 4**2*x3**2 + 15**2*x4**2 >= 43)
m.addConstr(18*x1 + 31*x2 + 4*x3 + 15*x4 + 8*x5 + 28*x6 >= 43)
m.addConstr(5*x1**2 - 5*x6**2 >= 0)
m.addConstr(2*x1 - x3 >= 0)
m.addConstr(5*x1**2 - 4*x3**2 + 5*x6**2 >= 0)
m.addConstr(8*x5 + 28*x6 <= 252)
m.addConstr(18*x1 + 8*x5 <= 352)
m.addConstr(31*x2 + 15*x4 <= 124)
m.addConstr(31*x2 + 8*x5 <= 173)
m.addConstr(15*x4 + 28*x6 <= 307)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Diapers: ", x1.varValue)
    print("Candles: ", x2.varValue)
    print("Dish soap bottles: ", x3.varValue)
    print("Toilet paper rolls: ", x4.varValue)
    print("Bottles of ibuprofen: ", x5.varValue)
    print("Lightbulbs: ", x6.varValue)
else:
    print("The model is infeasible or unbounded.")
