
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(name="hours worked by Peggy")
    x1 = model.addVar(name="hours worked by Ringo")
    x2 = model.addVar(name="hours worked by Paul")


    # Set objective function
    model.setObjective(8.67*x0**2 + 2.18*x0*x1 + 8.93*x0*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17*x0**2 + 5*x1**2 >= 33)
    model.addConstr(17*x0**2 + 4*x2**2 >= 30)
    model.addConstr(17*x0 + 5*x1 + 4*x2 >= 69)
    model.addConstr(22*x1**2 + 11*x2**2 >= 59)
    model.addConstr(22*x0**2 + 22*x1**2 >= 86)
    model.addConstr(22*x0 + 22*x1 + 11*x2 >= 86)
    model.addConstr(x0 - 4*x1 >= 0)
    model.addConstr(-5*x0**2 + 9*x2**2 >= 0)
    model.addConstr(17*x0 + 5*x1 + 4*x2 <= 114)
    model.addConstr(22*x0 + 22*x1 <= 238)
    model.addConstr(22*x1 + 11*x2 <= 132)
    model.addConstr(22*x0**2 + 22*x1**2 + 11*x2**2 <= 140)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
