
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # hours worked by Peggy
x1 = m.addVar(name="hours_worked_by_Ringo", lb=0)  # hours worked by Ringo
x2 = m.addVar(name="hours_worked_by_Paul", lb=0)   # hours worked by Paul

# Objective function
m.setObjective(8.67 * x0**2 + 2.18 * x0 * x1 + 8.93 * x0 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(17 * x0 <= 236)  # Peggy computer competence
m.addConstr(22 * x0 <= 284)  # Peggy likelihood to quit
m.addConstr(5 * x1 <= 236)   # Ringo computer competence
m.addConstr(22 * x1 <= 284)  # Ringo likelihood to quit
m.addConstr(4 * x2 <= 236)   # Paul computer competence
m.addConstr(11 * x2 <= 284)  # Paul likelihood to quit

m.addConstr(17**2 * x0**2 + 5**2 * x1**2 >= 33)  # combined computer competence from x0, x1
m.addConstr(17**2 * x0**2 + 4**2 * x2**2 >= 30)  # combined computer competence from x0, x2
m.addConstr(17 * x0 + 5 * x1 + 4 * x2 >= 69)      # total combined computer competence

m.addConstr(22 * x0 + 22 * x1 + 11 * x2 >= 86)   # total combined likelihood to quit
m.addConstr(22**2 * x0**2 + 22**2 * x1**2 >= 86) # combined likelihood to quit from x0, x1

m.addConstr(x0 - 4 * x1 >= 0)                  # relationship between x0 and x1
m.addConstr(-5 * x0**2 + 9 * x2**2 >= 0)       # relationship between x0 and x2

m.addConstr(17 * x0 + 5 * x1 + 4 * x2 <= 114)   # upper limit on total computer competence
m.addConstr(22 * x0 + 22 * x1 <= 238)           # limit on combined likelihood to quit from x0, x1
m.addConstr(22 * x1 + 11 * x2 <= 132)           # limit on combined likelihood to quit from x1, x2

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Peggy: ", x0.varValue)
    print("Hours worked by Ringo: ", x1.varValue)
    print("Hours worked by Paul: ", x2.varValue)
else:
    print("The model is infeasible")
