
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
eggs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")
chicken_breasts = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")
rotisserie_chickens = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")


# Set objective function
m.setObjective(4.49*eggs**2 + 3.26*chicken_breasts**2 + 6.01*chicken_breasts*rotisserie_chickens + 6.69*chicken_breasts + 3.59*rotisserie_chickens, GRB.MINIMIZE)

# Add constraints
m.addConstr(6.74*chicken_breasts + 5.11*rotisserie_chickens >= 24)
m.addConstr(4.18*eggs + 6.74*chicken_breasts + 5.11*rotisserie_chickens >= 24)
m.addConstr(0.06*chicken_breasts + 3.0*rotisserie_chickens >= 30)
m.addConstr(6.87*eggs + 3.0*rotisserie_chickens >= 24)
m.addConstr(6.87*eggs + 0.06*chicken_breasts + 3.0*rotisserie_chickens >= 24)
m.addConstr(-10*chicken_breasts + 5*rotisserie_chickens >= 0)
m.addConstr(5*eggs**2 - 9*rotisserie_chickens**2 >= 0)
m.addConstr(4.18*eggs + 6.74*chicken_breasts <= 91)
m.addConstr(6.74*chicken_breasts**2 + 5.11*rotisserie_chickens**2 <= 77)
m.addConstr(0.06*chicken_breasts + 3.0*rotisserie_chickens <= 64)

# Resource Constraints
m.addConstr(4.18*eggs <= 108)
m.addConstr(6.87*eggs <= 106)
m.addConstr(6.74*chicken_breasts <= 108)
m.addConstr(0.06*chicken_breasts <= 106)
m.addConstr(5.11*rotisserie_chickens <= 108)
m.addConstr(3.0*rotisserie_chickens <= 106)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('eggs:', eggs.x)
    print('chicken_breasts:', chicken_breasts.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

