
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="eggs", lb=-gurobi.GRB.INFINITY)
x1 = model.addVar(name="chicken breasts", lb=-gurobi.GRB.INFINITY)
x2 = model.addVar(name="rotisserie chickens", lb=-gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(4.49*x0**2 + 3.26*x1**2 + 6.01*x1*x2 + 6.69*x1 + 3.59*x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(6.74*x1 + 5.11*x2 >= 24)
model.addConstr(4.18*x0 + 6.74*x1 + 5.11*x2 >= 24)
model.addConstr(0.06*x1 + 3.0*x2 >= 30)
model.addConstr(6.87*x0 + 3.0*x2 >= 24)
model.addConstr(6.87*x0 + 0.06*x1 + 3.0*x2 >= 24)
model.addConstr(-10*x1 + 5*x2 >= 0)
model.addConstr(5*x0**2 - 9*x2**2 >= 0)
model.addConstr(4.18*x0 + 6.74*x1 <= 91)
model.addConstr((6.74*x1)**2 + (5.11*x2)**2 <= 77)
model.addConstr(0.06*x1 + 3.0*x2 <= 64)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Eggs: ", x0.varValue)
    print("Chicken Breasts: ", x1.varValue)
    print("Rotisserie Chickens: ", x2.varValue)
else:
    print("The model is infeasible")
