
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fruit_optimization")

# Create variables
kiwis = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
fruit_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="fruit_salads")
apples = m.addVar(lb=0, vtype=GRB.INTEGER, name="apples")


# Set objective function
m.setObjective(4*kiwis**2 + 3*kiwis*fruit_salads + 4*kiwis*apples + 2*fruit_salads**2 + 9*fruit_salads*apples + 8*apples**2 + 4*fruit_salads + 6*apples, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*kiwis + 11*apples <= 236, "c1")
m.addConstr(17*kiwis + 9*fruit_salads + 11*apples <= 236, "c2")
m.addConstr(17*kiwis + 9*fruit_salads + 11*apples <= 242, "c3")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('kiwis:', kiwis.x)
    print('fruit_salads:', fruit_salads.x)
    print('apples:', apples.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

