
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="kiwis")
x2 = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")
x3 = m.addVar(vtype=GRB.INTEGER, name="apples")

# Set the objective function
m.setObjective(4*x1**2 + 3*x1*x2 + 4*x1*x3 + 2*x2**2 + 9*x2*x3 + 8*x3**2 + 4*x2 + 6*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x1 + 11*x3 <= 236, name="umami_index_kiwis_apples")
m.addConstr(17*x1 + 9*x2 + 11*x3 <= 236, name="total_umami_index")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kiwis: {x1.x}")
    print(f"Fruit Salads: {x2.x}")
    print(f"Apples: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
