
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="kiwis", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="fruit_salads", lb=0, vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="apples", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(4*x1**2 + 3*x1*x2 + 4*x1*x3 + 2*x2**2 + 9*x2*x3 + 8*x3**2 + 4*x2 + 6*x3, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(17*x1 + 11*x3 <= 236)
m.addConstr(17*x1 + 9*x2 + 11*x3 <= 236)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Kiwis: {x1.varValue}")
    print(f"Fruit Salads: {x2.varValue}")
    print(f"Apples: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
