
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
magnesium = m.addVar(lb=0, name="magnesium")
carbohydrates = m.addVar(lb=0, name="carbohydrates")
fat = m.addVar(lb=0, name="fat")
vitamin_c = m.addVar(lb=0, name="vitamin_c")

# Set objective function
m.setObjective(4.55 * magnesium + 1.85 * carbohydrates + 5.52 * fat + 5.81 * vitamin_c, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * fat + 27 * vitamin_c >= 25)
m.addConstr(29 * magnesium + 10 * fat >= 33)
m.addConstr(14 * carbohydrates + 10 * fat >= 21)
m.addConstr(29 * magnesium + 14 * carbohydrates >= 19)
m.addConstr(29 * magnesium + 14 * carbohydrates + 10 * fat + 27 * vitamin_c >= 19)
m.addConstr(31 * fat + 13 * vitamin_c >= 22)
m.addConstr(23 * magnesium + 4 * carbohydrates + 31 * fat >= 30)
m.addConstr(4 * carbohydrates + 31 * fat + 13 * vitamin_c >= 30)
m.addConstr(23 * magnesium + 31 * fat + 13 * vitamin_c >= 30)
m.addConstr(23 * magnesium + 4 * carbohydrates + 31 * fat >= 28)
m.addConstr(4 * carbohydrates + 31 * fat + 13 * vitamin_c >= 28)
m.addConstr(23 * magnesium + 31 * fat + 13 * vitamin_c >= 28)
m.addConstr(23 * magnesium + 4 * carbohydrates + 31 * fat >= 27)
m.addConstr(4 * carbohydrates + 31 * fat + 13 * vitamin_c >= 27)
m.addConstr(23 * magnesium + 31 * fat + 13 * vitamin_c >= 27)
m.addConstr(23 * magnesium + 4 * carbohydrates + 31 * fat + 13 * vitamin_c >= 27)
m.addConstr(-6 * magnesium + 10 * fat >= 0)
m.addConstr(29 * magnesium + 10 * fat <= 141)
m.addConstr(29 * magnesium + 27 * vitamin_c <= 145)
m.addConstr(10 * fat + 27 * vitamin_c <= 48)
m.addConstr(29 * magnesium + 14 * carbohydrates + 27 * vitamin_c <= 45)
m.addConstr(14 * carbohydrates + 10 * fat + 27 * vitamin_c <= 115)
m.addConstr(23 * magnesium + 13 * vitamin_c <= 102)
m.addConstr(23 * magnesium + 31 * fat <= 37)

# Resource constraints
m.addConstr(29 * magnesium + 14 * carbohydrates + 10 * fat + 27 * vitamin_c <= 145)
m.addConstr(23 * magnesium + 4 * carbohydrates + 31 * fat + 13 * vitamin_c <= 129)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

