
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="milligrams of magnesium", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="grams of carbohydrates", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="grams of fat", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams of vitamin C", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(4.55 * x0 + 1.85 * x1 + 5.52 * x2 + 5.81 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(29 * x0 <= 145)
m.addConstr(23 * x0 <= 129)
m.addConstr(10 * x2 + 27 * x3 >= 25)
m.addConstr(29 * x0 + 10 * x2 >= 33)
m.addConstr(14 * x1 + 10 * x2 >= 21)
m.addConstr(29 * x0 + 14 * x1 >= 19)
m.addConstr(29 * x0 + 14 * x1 + 10 * x2 + 27 * x3 >= 19)
m.addConstr(31 * x2 + 13 * x3 >= 22)
m.addConstr(23 * x0 + 4 * x1 + 31 * x2 >= 30)
m.addConstr(4 * x1 + 31 * x2 + 13 * x3 >= 30)
m.addConstr(23 * x0 + 31 * x2 + 13 * x3 >= 30)
m.addConstr(23 * x0 + 4 * x1 + 31 * x2 >= 28)
m.addConstr(4 * x1 + 31 * x2 + 13 * x3 >= 28)
m.addConstr(23 * x0 + 31 * x2 + 13 * x3 >= 28)
m.addConstr(23 * x0 + 4 * x1 + 31 * x2 >= 27)
m.addConstr(4 * x1 + 31 * x2 + 13 * x3 >= 27)
m.addConstr(23 * x0 + 31 * x2 + 13 * x3 >= 27)
m.addConstr(23 * x0 + 4 * x1 + 31 * x2 + 13 * x3 >= 27)
m.addConstr(-6 * x0 + 10 * x2 >= 0)
m.addConstr(29 * x0 + 10 * x2 <= 141)
m.addConstr(29 * x0 + 27 * x3 <= 145)
m.addConstr(10 * x2 + 27 * x3 <= 48)
m.addConstr(29 * x0 + 14 * x1 + 27 * x3 <= 45)
m.addConstr(14 * x1 + 10 * x2 + 27 * x3 <= 115)
m.addConstr(23 * x0 + 13 * x3 <= 102)
m.addConstr(23 * x0 + 31 * x2 <= 37)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of magnesium: {x0.varValue}")
    print(f"Grams of carbohydrates: {x1.varValue}")
    print(f"Grams of fat: {x2.varValue}")
    print(f"Milligrams of vitamin C: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
