
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="grams_of_fiber")
    x1 = m.addVar(name="milligrams_of_vitamin_C")
    x2 = m.addVar(name="grams_of_fat")


    # Set objective function
    m.setObjective(7.06*x0**2 + 5.0*x0*x1 + 3.09*x0*x2 + 6.69*x1**2 + 9.81*x1*x2 + 2.62*x1 + 5.08*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(21*x1 + 27*x2 >= 46, "c1")
    m.addConstr(21*x0**2 + 21*x1**2 >= 50, "c2")
    m.addConstr(21*x0 + 21*x1 + 27*x2 >= 50, "c3")
    m.addConstr(17*x1 + 17*x2 >= 33, "c4")
    m.addConstr(10*x0 + 17*x2 >= 24, "c5")
    m.addConstr(10*x0 + 17*x1 + 17*x2 >= 24, "c6")
    m.addConstr(-7*x0 + 4*x1 >= 0, "c7")
    m.addConstr(21*x0 + 21*x1 <= 155, "c8")
    m.addConstr(21*x0 + 21*x1 + 27*x2 <= 182, "c9")
    m.addConstr(17*x1 + 17*x2 <= 107, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

