
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(7.06*x1**2 + 5.0*x1*x2 + 3.09*x1*x3 + 6.69*x2**2 + 9.81*x2*x3 + 2.62*x2 + 5.08*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(21*x1 <= 199)
    model.addConstr(10*x1 <= 123)
    model.addConstr(21*x2 <= 199)
    model.addConstr(17*x2 <= 123)
    model.addConstr(27*x3 <= 199)
    model.addConstr(17*x3 <= 123)
    model.addConstr(21*x2 + 27*x3 >= 46)
    model.addConstr(21*x1 + 21*x2 + 27*x3 >= 50)
    model.addConstr(17*x2 + 17*x3 >= 33)
    model.addConstr(10*x1 + 17*x3 >= 24)
    model.addConstr(10*x1 + 17*x2 + 17*x3 >= 24)
    model.addConstr(-7*x1 + 4*x2 >= 0)
    model.addConstr(21*x1 + 21*x2 <= 155)
    model.addConstr(21*x1 + 21*x2 + 27*x3 <= 182)
    model.addConstr(17*x2 + 17*x3 <= 107)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
