
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_likelihood")

    # Create variables
    hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
    mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
    paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")


    # Set objective
    m.setObjective(1.4*hank*mary + 3.28*hank*paul + 4.19*mary*mary + 4.96*hank + 3.96*mary, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*hank == 3, "c0")
    m.addConstr(7*mary == 7, "c1")
    m.addConstr(7*paul == 7, "c2")
    m.addConstr(3*hank + 7*paul >= 4, "c3")
    m.addConstr(7*mary + 7*paul >= 4, "c4")
    m.addConstr(3*hank + 7*mary + 7*paul >= 4, "c5")
    m.addConstr(5*hank - 8*mary >= 0, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('hank:', hank.x)
        print('mary:', mary.x)
        print('paul:', paul.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
