
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Hank")
x2 = m.addVar(lb=0, name="hours_worked_by_Mary")
x3 = m.addVar(lb=0, name="hours_worked_by_Paul")

# Set the objective function
m.setObjective(1.4*x1*x2 + 3.28*x1*x3 + 4.19*x2**2 + 4.96*x1 + 3.96*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 - 8*x2 >= 0, name="constraint_1")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Hank:", x1.x)
    print("Hours worked by Mary:", x2.x)
    print("Hours worked by Paul:", x3.x)
else:
    print("No optimal solution found")
