
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Mary
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Paul

    # Objective function
    model.setObjective(1.4*x1*x2 + 3.28*x1*x3 + 4.19*x2**2 + 4.96*x1 + 3.96*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x1 <= 39)  
    model.addConstr(7*x2 <= 39)  
    model.addConstr(7*x3 <= 39)  
    model.addConstr(3*x1 + 7*x3 >= 4)  
    model.addConstr(7*x2 + 7*x3 >= 4)  
    model.addConstr(3*x1 + 7*x2 + 7*x3 >= 4)  
    model.addConstr(5*x1 - 8*x2 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Hank: ", x1.varValue)
        print("Hours worked by Mary: ", x2.varValue)
        print("Hours worked by Paul: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
