
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="water_purification_units")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="medical_platoons")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="artillery_batteries")


# Set objective function
m.setObjective(3*x0 + 4*x1 + 4*x2 + 5*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 16*x3 >= 49)
m.addConstr(3*x1 + 16*x3 >= 51)
m.addConstr(2*x0 + 3*x1 + 16*x2 >= 71)
m.addConstr(2*x0 + 16*x2 + 16*x3 >= 71)
m.addConstr(3*x1 + 16*x2 + 16*x3 >= 71)
m.addConstr(2*x0 + 3*x1 + 16*x3 >= 71)
m.addConstr(2*x0 + 3*x1 + 16*x2 >= 58)
m.addConstr(2*x0 + 16*x2 + 16*x3 >= 58)
m.addConstr(3*x1 + 16*x2 + 16*x3 >= 58)
m.addConstr(2*x0 + 3*x1 + 16*x3 >= 58)
m.addConstr(2*x0 + 3*x1 + 16*x2 >= 46)
m.addConstr(2*x0 + 16*x2 + 16*x3 >= 46)
m.addConstr(3*x1 + 16*x2 + 16*x3 >= 46)
m.addConstr(2*x0 + 3*x1 + 16*x3 >= 46)
m.addConstr(2*x0 + 3*x1 + 16*x2 >= 41)
m.addConstr(2*x0 + 16*x2 + 16*x3 >= 41)
m.addConstr(3*x1 + 16*x2 + 16*x3 >= 41)
m.addConstr(2*x0 + 3*x1 + 16*x3 >= 41)
m.addConstr(2*x0 + 3*x1 + 16*x2 + 16*x3 >= 41)
m.addConstr(16*x2 + 13*x3 >= 30)
m.addConstr(5*x0 + 17*x1 >= 19)
m.addConstr(5*x0 + 13*x3 >= 47)
m.addConstr(17*x1 + 13*x3 >= 50)
m.addConstr(17*x1 + 16*x2 >= 42)
m.addConstr(5*x0 + 17*x1 + 16*x2 >= 46)
m.addConstr(17*x1 + 16*x2 + 13*x3 >= 46)
m.addConstr(5*x0 + 17*x1 + 16*x2 >= 47)
m.addConstr(17*x1 + 16*x2 + 13*x3 >= 47)
m.addConstr(5*x0 + 17*x1 + 16*x2 + 13*x3 >= 47)
m.addConstr(9*x1 + 10*x3 >= 20)
m.addConstr(7*x0 + 13*x2 >= 36)
m.addConstr(7*x0 + 9*x1 + 13*x2 + 10*x3 >= 36)
m.addConstr(9*x0 + 8*x1 >= 37)
m.addConstr(9*x0 + 6*x2 >= 36)
m.addConstr(8*x1 + 6*x2 + 15*x3 >= 49)
m.addConstr(9*x0 + 8*x1 + 6*x2 + 15*x3 >= 49)
m.addConstr(-1*x0 + 8*x3 >= 0)
m.addConstr(-6*x2 + 3*x3 >= 0)
m.addConstr(2*x0 + 16*x2 + 16*x3 <= 165)
m.addConstr(5*x0 + 17*x1 <= 77)
m.addConstr(16*x2 + 13*x3 <= 107)
m.addConstr(7*x0 + 13*x2 <= 92)
m.addConstr(9*x1 + 10*x3 <= 157)
m.addConstr(8*x1 + 6*x2 <= 180)
m.addConstr(8*x1 + 6*x2 + 15*x3 <= 190)
m.addConstr(9*x0 + 8*x1 + 6*x2 <= 144)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

