
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("minimize_cost")

# Create variables
rotisserie_chickens = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
apples = m.addVar(vtype=GRB.CONTINUOUS, name="apples")

# Set objective function
m.setObjective(8.8 * rotisserie_chickens + 7.52 * apples, GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * rotisserie_chickens + 12 * apples >= 11, "fat_constraint")
m.addConstr(4 * rotisserie_chickens + 10 * apples >= 11, "cost_constraint_min")
m.addConstr(10 * rotisserie_chickens - 6 * apples >= 0, "chicken_apple_ratio")
m.addConstr(1 * rotisserie_chickens + 12 * apples <= 43, "fat_constraint_upper")
m.addConstr(4 * rotisserie_chickens + 10 * apples <= 55, "cost_constraint_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Rotisserie Chickens: {rotisserie_chickens.x}")
    print(f"Apples: {apples.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

