
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="apples")

# Set objective function
m.setObjective(8.8*x0 + 7.52*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(x0 + 12*x1 >= 11, "fat_minimum")
m.addConstr(4*x0 + 10*x1 >= 11, "cost_minimum")
m.addConstr(4*x0 + 10*x1 <= 55, "cost_maximum")
m.addConstr(10*x0 - 6*x1 >= 0, "additional_constraint")
m.addConstr(x0 + 12*x1 <= 43, "fat_upper_bound")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rotisserie chickens: {x0.x}")
    print(f"Apples: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
