
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER, lb=0)
x2 = model.addVar(name="apples", vtype=gurobi.GRB.CONTINUOUS, lb=0)

# Set the objective function
model.setObjective(8.8 * x1 + 7.52 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(1 * x1 + 12 * x2 >= 11, name="fat_constraint")
model.addConstr(4 * x1 + 10 * x2 >= 11, name="cost_constraint")
model.addConstr(10 * x1 - 6 * x2 >= 0, name="mix_constraint")
model.addConstr(1 * x1 + 12 * x2 <= 43, name="max_fat_constraint")
model.addConstr(4 * x1 + 10 * x2 <= 55, name="max_cost_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Rotisserie chickens: {x1.varValue}")
    print(f"Apples: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
