
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["fiber", "vitamin_B2", "vitamin_K", "magnesium", "vitamin_C", "vitamin_D"])

# Set objective function
m.setObjective(1*x[0] + 2*x[1] + 5*x[2] + 1*x[3] + 9*x[4] + 8*x[5], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x[0] + 6*x[1] + 3*x[2] + 10*x[3] + 10*x[4] + 2*x[5] <= 392, "r0_upper_bound")
m.addConstr(10*x[4] + 2*x[5] >= 56, "c1")
m.addConstr(3*x[2] + 10*x[4] >= 27, "c2")
m.addConstr(6*x[1] + 2*x[5] >= 39, "c3")
m.addConstr(6*x[1] + 3*x[2] >= 51, "c4")
m.addConstr(3*x[0] + 2*x[5] >= 44, "c5")
m.addConstr(3*x[0] + 6*x[1] >= 45, "c6")
m.addConstr(3*x[0] + 10*x[3] >= 21, "c7")
m.addConstr(10*x[3] + 2*x[5] >= 29, "c8")
m.addConstr(3*x[2] + 10*x[3] >= 54, "c9")
m.addConstr(3*x[2] + 2*x[5] >= 26, "c10")
m.addConstr(6*x[1] + 3*x[2] + 10*x[3] >= 45, "c11")
m.addConstr(6*x[1] + 10*x[3] + 2*x[5] >= 45, "c12")
m.addConstr(6*x[1] + 3*x[2] + 10*x[3] >= 61, "c13")
m.addConstr(6*x[1] + 10*x[3] + 2*x[5] >= 61, "c14")
m.addConstr(3*x[0] + 6*x[1] + 3*x[2] + 10*x[3] + 10*x[4] + 2*x[5] >= 61, "c15")
m.addConstr(-5*x[0] + 2*x[3] >= 0, "c16")
m.addConstr(1*x[4] - 9*x[5] >= 0, "c17")
m.addConstr(1*x[0] - 3*x[4] >= 0, "c18")
m.addConstr(6*x[1] + 2*x[5] <= 215, "c19")
m.addConstr(6*x[1] + 10*x[3] <= 247, "c20")
m.addConstr(3*x[0] + 6*x[1] <= 336, "c21")
m.addConstr(3*x[0] + 10*x[3] <= 214, "c22")
m.addConstr(10*x[3] + 10*x[4] <= 264, "c23")
m.addConstr(3*x[2] + 10*x[3] <= 93, "c24")
m.addConstr(3*x[2] + 2*x[5] <= 242, "c25")
m.addConstr(3*x[0] + 2*x[5] <= 352, "c26")
m.addConstr(6*x[1] + 3*x[2] <= 350, "c27")
m.addConstr(3*x[0] + 10*x[4] <= 273, "c28")
m.addConstr(6*x[1] + 10*x[4] <= 154, "c29")
m.addConstr(3*x[0] + 3*x[2] <= 238, "c30")
m.addConstr(3*x[0] + 10*x[3] + 2*x[5] <= 323, "c31")
m.addConstr(3*x[0] + 10*x[4] + 2*x[5] <= 213, "c32")
m.addConstr(3*x[0] + 3*x[2] + 2*x[5] <= 189, "c33")
m.addConstr(3*x[0] + 3*x[2] + 10*x[3] <= 184, "c34")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

