
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # grams of fiber
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin B2
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin K
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x4")  # milligrams of magnesium
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x5")  # milligrams of vitamin C
    x6 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x6")  # milligrams of vitamin D

    # Objective function
    model.setObjective(1*x1 + 2*x2 + 5*x3 + 1*x4 + 9*x5 + 8*x6, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x1 <= 392)
    model.addConstr(6*x2 <= 392)
    model.addConstr(3*x3 <= 392)
    model.addConstr(10*x4 <= 392)
    model.addConstr(10*x5 <= 392)
    model.addConstr(2*x6 <= 392)
    model.addConstr(10*x5 + 2*x6 >= 56)
    model.addConstr(3*x3 + 10*x5 >= 27)
    model.addConstr(6*x2 + 2*x6 >= 39)
    model.addConstr(6*x2 + 3*x3 >= 51)
    model.addConstr(3*x1 + 2*x6 >= 44)
    model.addConstr(3*x1 + 6*x2 >= 45)
    model.addConstr(3*x1 + 10*x4 >= 21)
    model.addConstr(10*x4 + 2*x6 >= 29)
    model.addConstr(3*x3 + 10*x4 >= 54)
    model.addConstr(3*x3 + 2*x6 >= 26)
    model.addConstr(6*x2 + 3*x3 + 10*x4 >= 45)
    model.addConstr(6*x2 + 10*x4 + 2*x6 >= 45)
    model.addConstr(6*x2 + 3*x3 + 10*x4 >= 61)
    model.addConstr(6*x2 + 10*x4 + 2*x6 >= 61)
    model.addConstr(3*x1 + 6*x2 + 3*x3 + 10*x4 + 10*x5 + 2*x6 >= 61)
    model.addConstr(-5*x1 + 2*x4 >= 0)
    model.addConstr(1*x5 - 9*x6 >= 0)
    model.addConstr(1*x1 - 3*x5 >= 0)
    model.addConstr(6*x2 + 2*x6 <= 215)
    model.addConstr(6*x2 + 10*x4 <= 247)
    model.addConstr(3*x1 + 6*x2 <= 336)
    model.addConstr(3*x1 + 10*x4 <= 214)
    model.addConstr(10*x4 + 10*x5 <= 264)
    model.addConstr(3*x3 + 10*x4 <= 93)
    model.addConstr(3*x3 + 2*x6 <= 242)
    model.addConstr(3*x1 + 2*x6 <= 352)
    model.addConstr(6*x2 + 3*x3 <= 350)
    model.addConstr(3*x1 + 10*x5 <= 273)
    model.addConstr(6*x2 + 10*x5 <= 154)
    model.addConstr(3*x1 + 3*x3 <= 238)
    model.addConstr(3*x1 + 10*x4 + 2*x6 <= 323)
    model.addConstr(3*x1 + 10*x5 + 2*x6 <= 213)
    model.addConstr(3*x1 + 3*x3 + 2*x6 <= 189)
    model.addConstr(3*x1 + 3*x3 + 10*x4 <= 184)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
