
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.INTEGER, name=["color_printers", "rubber_bands", "hole_punches", "packs_of_paper", "planners", "3D_printers"])


# Set objective function
m.setObjective(3*x[0] + 8*x[1] + 7*x[2] + 5*x[3] + 7*x[4] + 9*x[5], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * x[1] + 10 * x[5] >= 15)
m.addConstr(8 * x[2] + 10 * x[5] >= 13)
m.addConstr(8 * x[2] + 1 * x[3] >= 14)
m.addConstr(9 * x[0] + 8 * x[4] >= 27)
m.addConstr(1 * x[3] + 8 * x[4] >= 17)
m.addConstr(1 * x[3] + 10 * x[5] >= 18)
m.addConstr(4 * x[1] + 1 * x[3] >= 23)
m.addConstr(9 * x[0] + 4 * x[1] >= 25)
m.addConstr(9 * x[0] + 1 * x[3] >= 24)
# ... (add all other constraints similarly)


# Resource constraints
resource_data = {
    'r0': {'upper_bound': 164, 'coefficients': [9, 4, 8, 1, 8, 10]},
    'r1': {'upper_bound': 123, 'coefficients': [10, 5, 1, 9, 2, 4]},
    'r2': {'upper_bound': 155, 'coefficients': [6, 3, 4, 2, 2, 6]},
    'r3': {'upper_bound': 169, 'coefficients': [4, 10, 8, 1, 7, 8]}
}

for resource, data in resource_data.items():
    m.addConstr(gp.quicksum(data['coefficients'][i] * x[i] for i in range(6)) <= data['upper_bound'], name=resource)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

