
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="color_printers", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="rubber_bands", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="hole_punches", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="planners", vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name="3D_printers", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(3*x0 + 8*x1 + 7*x2 + 5*x3 + 7*x4 + 9*x5, gurobi.GRB.MINIMIZE)

# Add constraints
# Sustainability score constraints
m.addConstr(4*x1 + 10*x5 >= 15)
m.addConstr(8*x2 + 10*x5 >= 13)
m.addConstr(8*x2 + x3 >= 14)
m.addConstr(9*x0 + 8*x4 >= 27)
m.addConstr(x3 + 8*x4 >= 17)
m.addConstr(x3 + 10*x5 >= 18)
m.addConstr(4*x1 + x3 >= 23)
m.addConstr(9*x0 + 4*x1 >= 25)
m.addConstr(9*x0 + x3 >= 24)
m.addConstr(4*x1 + 8*x4 >= 16)

# Weight constraints
m.addConstr(5*x1 + 9*x3 >= 18)
m.addConstr(5*x1 + x2 >= 19)
m.addConstr(10*x0 + x2 >= 10)
m.addConstr(5*x1 + 4*x5 >= 17)
m.addConstr(x2 + 4*x5 >= 14)
m.addConstr(9*x3 + 2*x4 >= 19)

# Storage space constraints
m.addConstr(6*x0 + 6*x5 >= 15)
m.addConstr(3*x1 + 2*x3 >= 21)
m.addConstr(6*x0 + 3*x1 >= 15)
m.addConstr(4*x2 + 2*x4 >= 10)
m.addConstr(6*x0 + 2*x3 >= 25)

# Cost constraints
m.addConstr(10*x1 + x3 >= 16)
m.addConstr(4*x0 + x3 >= 26)
m.addConstr(10*x1 + 8*x5 >= 15)
m.addConstr(4*x0 + 8*x2 >= 26)
m.addConstr(x3 + 7*x4 + 8*x5 >= 23)

# Miscellaneous constraints
m.addConstr(-3*x1 + 6*x5 >= 0)
m.addConstr(4*x1 + x3 + 10*x5 <= 145)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Color printers: ", x0.varValue)
    print("Rubber bands: ", x1.varValue)
    print("Hole punches: ", x2.varValue)
    print("Packs of paper: ", x3.varValue)
    print("Planners: ", x4.varValue)
    print("3D printers: ", x5.varValue)
else:
    print("No optimal solution found")
