
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="postage_stamps")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="staplers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="hole_punches")

    # Set objective function
    m.setObjective(3.31*x0**2 + 6.11*x0*x1 + 5.37*x1**2 + 7.52*x1*x2 + 2.38*x2**2 + 9.71*x1 + 9.72*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5*x0 + 13*x1 >= 78)
    m.addConstr(2*x0 + 26*x2 >= 143)
    m.addConstr(2*x0 + 20*x1 >= 137)
    m.addConstr(20*x1**2 + 26*x2**2 >= 63)
    m.addConstr(22*x0 + 18*x1 >= 82)
    m.addConstr(22*x0 + 28*x2 >= 76)
    m.addConstr(22*x0**2 + 18*x1**2 + 28*x2**2 >= 96)
    m.addConstr(-x0 + 6*x2 >= 0)
    m.addConstr(5*x0 + x2 <= 238)
    m.addConstr(5*x0 + 13*x1 <= 258)
    m.addConstr(13*x1 + x2 <= 169)
    m.addConstr(5*x0 + 13*x1 + x2 <= 169)
    m.addConstr(2*x0 + 20*x1 <= 418)
    m.addConstr(2*x0 + 20*x1 + 26*x2 <= 418)
    m.addConstr(22*x0 + 28*x2 <= 252)
    m.addConstr(22*x0 + 18*x1 + 28*x2 <= 252)
    m.addConstr(28*x0 + 6*x2 <= 193)
    m.addConstr(28*x0 + 12*x1 <= 336)
    m.addConstr(28*x0**2 + 12*x1**2 + 6*x2**2 <= 311)
    m.addConstr(28*x0 + 12*x1 + 6*x2 <= 311)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
