
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="staplers", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="hole_punches", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(3.31*x0**2 + 6.11*x0*x1 + 5.37*x1**2 + 7.52*x1*x2 + 2.38*x2**2 + 9.71*x1 + 9.72*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x0 + 13*x1 >= 78)
model.addConstr(2*x0 + 26*x2 >= 143)
model.addConstr(2*x0 + 20*x1 >= 137)
model.addConstr(20*x1**2 + 26*x2**2 >= 63)
model.addConstr(22*x0 + 18*x1 >= 82)
model.addConstr(22*x0 + 28*x2 >= 76)
model.addConstr(22*x0**2 + 18*x1**2 + 28*x2**2 >= 96)
model.addConstr(-x0 + 6*x2 >= 0)
model.addConstr(5*x0 + x2 <= 238)
model.addConstr(5*x0 + 13*x1 <= 258)
model.addConstr(13*x1 + x2 <= 169)
model.addConstr(5*x0 + 13*x1 + x2 <= 169)
model.addConstr(2*x0 + 20*x1 <= 418)
model.addConstr(2*x0 + 20*x1 + 26*x2 <= 418)
model.addConstr(22*x0 + 28*x2 <= 252)
model.addConstr(22*x0 + 18*x1 + 28*x2 <= 252)
model.addConstr(28*x0 + 12*x1 <= 193)
model.addConstr(28*x0 + 12*x1 <= 336)
model.addConstr(28*x0**2 + 12*x1**2 + 6*x2**2 <= 311)
model.addConstr(28*x0 + 12*x1 + 6*x2 <= 311)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Postage stamps: ", x0.varValue)
    print("Staplers: ", x1.varValue)
    print("Hole punches: ", x2.varValue)
else:
    print("The model is infeasible")
