
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_cost")

    # Create variables
    security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
    pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")

    # Set objective function
    m.setObjective(8 * security_onions + 6 * pen_testers, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10 * security_onions + 18 * pen_testers >= 42, "min_network_latency")
    m.addConstr(11 * security_onions + 3 * pen_testers >= 30, "min_data_accessibility")
    m.addConstr(2 * security_onions - 5 * pen_testers >= 0, "security_onions_vs_pen_testers")
    m.addConstr(10 * security_onions + 18 * pen_testers <= 58, "max_network_latency")
    m.addConstr(11 * security_onions + 3 * pen_testers <= 85, "max_data_accessibility")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('security_onions:', security_onions.x)
        print('pen_testers:', pen_testers.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

