
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Add variables
x0 = m.addVar(vtype=GRB.INTEGER, name="security_onions")
x1 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")

# Set objective function
m.setObjective(8*x0 + 6*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x0 + 18*x1 >= 42, "min_network_latency")
m.addConstr(10*x0 + 18*x1 <= 58, "max_network_latency")
m.addConstr(11*x0 + 3*x1 >= 30, "min_data_accessibility")
m.addConstr(11*x0 + 3*x1 <= 85, "max_data_accessibility")
m.addConstr(2*x0 - 5*x1 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Security Onions: {x0.x}")
    print(f"Pen Testers: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
