
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="security_onions", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(8 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 18 * x2 >= 42, name="network_latency_impact")
    model.addConstr(11 * x1 + 3 * x2 >= 30, name="data_accessibility_impact_min")
    model.addConstr(2 * x1 - 5 * x2 >= 0, name="relationship_between_security_onions_and_pen_testers")
    model.addConstr(10 * x1 + 18 * x2 <= 58, name="network_latency_upper_bound")
    model.addConstr(11 * x1 + 3 * x2 <= 85, name="data_accessibility_impact_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Security Onions: {x1.varValue}")
        print(f"Pen Testers: {x2.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
