
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['rotisserie chickens', 'potatoes', 'green beans', 'eggs', 'cheeseburgers', 'sashimi', 'granola bars', 'steaks']
x = m.addVars(len(foods), vtype=gp.GRB.INTEGER, name=foods)

# Set objective function
obj = 5.04 * x[0] + 8.52 * x[1] + 1.17 * x[2] + 5.43 * x[3] + 7.89 * x[4] + 1.64 * x[5] + 9.34 * x[6] + 6.19 * x[7]
m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints based on the provided resources/attributes
resources = {'r0': {'description': 'grams of fat', 'upper_bound': 411, 'x0': 8, 'x1': 16, 'x2': 9, 'x3': 19, 'x4': 8, 'x5': 1, 'x6': 8, 'x7': 12}, 'r1': {'description': 'umami index', 'upper_bound': 452, 'x0': 17, 'x1': 20, 'x2': 19, 'x3': 16, 'x4': 8, 'x5': 13, 'x6': 9, 'x7': 12}}

for r_key, r_data in resources.items():
    m.addConstr(gp.quicksum(r_data[f'x{i}'] * x[i] for i in range(len(foods))) <= r_data['upper_bound'], name=r_data['description'])


# Add the additional constraints provided in the input
constraints = [
    (16*x[1] + 8*x[6] >= 37),
    (8*x[0] + 12*x[7] >= 25),
    (19*x[3] + 12*x[7] >= 40),
    (8*x[6] + 12*x[7] >= 22),
    (x[5] + 8*x[6] + 12*x[7] >= 30),
    (16*x[1] + 19*x[3] + x[5] >= 30),
    (8*x[0] + 9*x[2] + 8*x[6] >= 30),
    (16*x[1] + 9*x[2] + 8*x[4] >= 30),
    (9*x[2] + x[5] + 8*x[6] >= 30),
    (19*x[3] + x[5] + 8*x[6] >= 30),
    (8*x[0] + 19*x[3] + 12*x[7] >= 30),
    (9*x[2] + 19*x[3] + x[5] >= 30),
    (8*x[0] + 8*x[4] + 12*x[7] >= 30),
    (16*x[1] + 9*x[2] + x[5] >= 30),
    (16*x[1] + 8*x[4] + 12*x[7] >= 30),
    (9*x[2] + 8*x[4] + x[5] >= 30),
    (19*x[3] + 8*x[4] + 8*x[6] >= 30),
    (8*x[0] + 16*x[1] + 8*x[4] >= 30),
    (16*x[1] + 9*x[2] + 19*x[3] >= 30),
    (9*x[2] + 19*x[3] + 8*x[4] >= 30),
    (8*x[4] + x[5] + 8*x[6] >= 30),
    (16*x[1] + 19*x[3] + 12*x[7] >= 30),
    (9*x[2] + 8*x[4] + 12*x[7] >= 30),
    (8*x[0] + 19*x[3] + 8*x[4] >= 30),
    (8*x[0] + 8*x[6] + 12*x[7] >= 30),
    (8*x[0] + 8*x[4] + 8*x[6] >= 30),
    (9*x[2] + 19*x[3] + 8*x[6] >= 30),
    (16*x[1] + 8*x[4] + x[5] >= 30),
    (19*x[3] + 8*x[6] + 12*x[7] >= 30),
    (17*x[0] + 20*x[1] >= 48),
    (20*x[1] + 8*x[4] >= 20),
    (20*x[1] + 13*x[5] >= 41),
    (16*x[3] + 13*x[5] >= 44),
    (8*x[4] + 12*x[7] >= 25),
    (19*x[2] + 8*x[4] >= 46),
    (13*x[5] + 12*x[7] >= 36),
    (17*x[0] + 8*x[4] >= 29),
    (19*x[2] + 12*x[7] >= 41),
    (9*x[6] + 12*x[7] >= 24),
    (17*x[0] + 19*x[2] >= 31),
    (19*x[2] + 16*x[3] >= 36),
    (19*x[2] + 9*x[6] >= 23),
    (20*x[1] + 19*x[2] >= 56),
    (-9*x[1] + x[5] >= 0),
    (-3*x[0] + 3*x[1] >= 0),
    (-4*x[2] + 10*x[6] >= 0),
    (-9*x[0] + 3*x[7] >= 0),
    (8*x[0] + x[5] <= 296),
    (8*x[4] + 8*x[6] <= 366),
    (16*x[1] + 12*x[7] <= 301),
    (19*x[3] + x[5] <= 95),
    (9*x[2] + 8*x[4] <= 268),
    (8*x[0] + 8*x[6] <= 237),
    (8*x[0] + 19*x[3] <= 307),
    (9*x[2] + 12*x[7] <= 266),
    (x[5] + 12*x[7] <= 340),
    (8*x[4] + x[5] <= 62),
    (8*x[0] + 16*x[1] <= 185),
    (19*x[3] + 8*x[4] <= 294),
    (19*x[3] + 12*x[7] <= 309),
    (9*x[2] + 19*x[3] <= 228)
]

for constraint in constraints:
    m.addConstr(constraint)


# Optimize model
m.optimize()

# Print solution or infeasibility message
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Compute IIS
    m.computeIIS()
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
