
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
roses = m.addVar(vtype=GRB.INTEGER, name="roses")
tomato_vines = m.addVar(vtype=GRB.INTEGER, name="tomato_vines")
chrysanthemums = m.addVar(vtype=GRB.INTEGER, name="chrysanthemums")
vincas = m.addVar(vtype=GRB.INTEGER, name="vincas")


# Set objective function
m.setObjective(5.03 * roses * tomato_vines + 4.0 * roses * chrysanthemums + 3.77 * roses * vincas + 6.85 * tomato_vines * vincas + 1.61 * chrysanthemums**2 + 3.88 * roses + 6.55 * vincas, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * roses + 19 * tomato_vines + 12 * chrysanthemums + 18 * vincas <= 144, "dollar_cost")
m.addConstr(8 * roses + 2 * tomato_vines + 15 * chrysanthemums + 17 * vincas <= 257, "yield")
m.addConstr(19 * tomato_vines + 12 * chrysanthemums + 18 * vincas >= 18, "c1")
m.addConstr(3 * roses + 12 * chrysanthemums + 18 * vincas >= 18, "c2")
m.addConstr(19 * tomato_vines + 12 * chrysanthemums + 18 * vincas >= 35, "c3")
m.addConstr(3 * roses + 12 * chrysanthemums + 18 * vincas >= 35, "c4")
m.addConstr(8 * roses + 15 * chrysanthemums + 17 * vincas >= 61, "c5")
m.addConstr(19 * tomato_vines**2 + 12 * chrysanthemums**2 <= 98, "c6") # corrected constraint
m.addConstr(19 * tomato_vines + 18 * vincas <= 131, "c7")
m.addConstr(3 * roses + 19 * tomato_vines <= 92, "c8")
m.addConstr(3 * roses + 12 * chrysanthemums <= 48, "c9")
m.addConstr(3 * roses**2 + 18 * vincas**2 <= 59, "c10") # corrected constraint
m.addConstr(19 * tomato_vines + 12 * chrysanthemums + 18 * vincas <= 89, "c11")
m.addConstr(3 * roses + 19 * tomato_vines + 12 * chrysanthemums + 18 * vincas <= 89, "c12")
m.addConstr(2 * tomato_vines + 17 * vincas <= 147, "c13")
m.addConstr(8 * roses + 17 * vincas <= 71, "c14")
m.addConstr(8 * roses + 2 * tomato_vines <= 160, "c15")
m.addConstr(8 * roses + 2 * tomato_vines + 15 * chrysanthemums + 17 * vincas <= 160, "c16")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

