
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # roses
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # tomato vines
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # chrysanthemums
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # vincas

    # Objective function
    model.setObjective(5.03*x0*x1 + 4.0*x0*x2 + 3.77*x0*x3 + 6.85*x1*x3 + 1.61*x2**2 + 3.88*x0 + 6.55*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x0 + 19*x1 + 12*x2 + 18*x3 <= 144)
    model.addConstr(8*x0 + 2*x1 + 15*x2 + 17*x3 <= 257)
    model.addConstr(19*x1 + 12*x2 + 18*x3 >= 18)
    model.addConstr(3*x0 + 12*x2 + 18*x3 >= 18)
    model.addConstr(19*x1 + 12*x2 + 18*x3 >= 35)
    model.addConstr(3*x0 + 12*x2 + 18*x3 >= 35)
    model.addConstr(8*x0 + 2*x1 + 15*x2 + 17*x3 >= 61)
    model.addConstr(19**2*x1**2 + 12**2*x2**2 <= 98)
    model.addConstr(19*x1 + 18*x3 <= 131)
    model.addConstr(3*x0 + 19*x1 <= 92)
    model.addConstr(3*x0 + 12*x2 <= 48)
    model.addConstr(3**2*x0**2 + 18**2*x3**2 <= 59)
    model.addConstr(19*x1 + 12*x2 + 18*x3 <= 89)
    model.addConstr(3*x0 + 19*x1 + 12*x2 + 18*x3 <= 89)
    model.addConstr(2*x1 + 17*x3 <= 147)
    model.addConstr(8*x0 + 17*x3 <= 71)
    model.addConstr(8*x0 + 2*x1 <= 160)
    model.addConstr(8*x0 + 2*x1 + 15*x2 + 17*x3 <= 160)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
