
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
    apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
    hamburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")


    # Set objective function
    m.setObjective(2*oranges + 2*apple_pies + 5*hamburgers, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*oranges + 13*apple_pies + 6*hamburgers <= 154, "c0")
    m.addConstr(13*oranges + 8*apple_pies + 15*hamburgers <= 134, "c1")
    m.addConstr(15*oranges + 18*apple_pies + 18*hamburgers <= 151, "c2")
    m.addConstr(13*apple_pies + 6*hamburgers >= 46, "c3")
    m.addConstr(4*oranges + 13*apple_pies >= 34, "c4")
    m.addConstr(4*oranges + 6*hamburgers >= 37, "c5")
    m.addConstr(4*oranges + 13*apple_pies + 6*hamburgers >= 37, "c6")
    m.addConstr(8*apple_pies + 15*hamburgers >= 30, "c7")
    m.addConstr(13*oranges + 8*apple_pies >= 43, "c8")
    m.addConstr(13*oranges + 8*apple_pies + 15*hamburgers >= 28, "c9")
    m.addConstr(15*oranges + 18*hamburgers >= 44, "c10")
    m.addConstr(15*oranges + 18*apple_pies >= 22, "c11")
    m.addConstr(15*oranges + 18*apple_pies + 18*hamburgers >= 22, "c12")
    m.addConstr(-8*oranges + 8*apple_pies >= 0, "c13")
    m.addConstr(4*oranges + 13*apple_pies + 6*hamburgers <= 153, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
