
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="oranges", lb=0, ub=gurobi.GRB.INFINITY)
x1 = m.addVar(name="apple_pies", lb=0, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="hamburgers", lb=0, ub=gurobi.GRB.INFINITY)

# Define the objective function
m.setObjective(2*x0 + 2*x1 + 5*x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x1 + 6*x2 >= 46, name="umami_ap_hb")
m.addConstr(4*x0 + 13*x1 >= 34, name="umami_o_ap")
m.addConstr(4*x0 + 6*x2 >= 37, name="umami_o_hb")
m.addConstr(4*x0 + 13*x1 + 6*x2 >= 37, name="umami_all")
m.addConstr(8*x1 + 15*x2 >= 30, name="fat_ap_hb")
m.addConstr(13*x0 + 8*x1 >= 43, name="fat_o_ap")
m.addConstr(13*x0 + 8*x1 + 15*x2 >= 28, name="fat_all")
m.addConstr(15*x0 + 18*x1 >= 22, name="carb_o_ap")
m.addConstr(13*x0 + 15*x2 >= 44, name="carb_o_hb")
m.addConstr(15*x0 + 18*x1 + 18*x2 >= 22, name="carb_all")
m.addConstr(-8*x0 + 8*x1 >= 0, name="oranges_apples")
m.addConstr(4*x0 + 13*x1 + 6*x2 <= 154, name="total_umami")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oranges: ", x0.varValue)
    print("Apple Pies: ", x1.varValue)
    print("Hamburgers: ", x2.varValue)
else:
    print("The model is infeasible")
