
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Work_Optimization")

    # Create variables
    ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
    bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
    george = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="george")
    laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")


    # Set objective function
    model.setObjective(1.82 * ringo + 5.26 * bobby + 3.54 * george + 6.15 * laura, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11 * ringo + 10 * bobby >= 65, "c1")
    model.addConstr(1 * george + 15 * laura >= 40, "c2")
    model.addConstr(10 * bobby + 1 * george + 15 * laura >= 57, "c3")
    model.addConstr(11 * ringo + 10 * bobby + 1 * george >= 57, "c4")
    model.addConstr(11 * ringo + 1 * george + 15 * laura >= 57, "c5")
    model.addConstr(1 * george + 15 * laura <= 250, "c6")
    model.addConstr(11 * ringo + 10 * bobby <= 244, "c7")
    model.addConstr(10 * bobby + 1 * george <= 151, "c8")
    model.addConstr(11 * ringo + 10 * bobby + 1 * george + 15 * laura <= 151, "c9")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Ringo:', ringo.x)
        print('Bobby:', bobby.x)
        print('George:', george.x)
        print('Laura:', laura.x)

    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
        model.computeIIS()
        model.write("model.ilp")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
