
import gurobi

def optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define the variables
    x1 = m.addVar(name="x1", lb=0)  # hours worked by Ringo
    x2 = m.addVar(name="x2", lb=0)  # hours worked by Bobby
    x3 = m.addVar(name="x3", lb=0, integrality=gurobi.GRB.INTEGER)  # hours worked by George
    x4 = m.addVar(name="x4", lb=0)  # hours worked by Laura

    # Objective function
    m.setObjective(1.82*x1 + 5.26*x2 + 3.54*x3 + 6.15*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(11*x1 <= 274)
    m.addConstr(10*x2 <= 274)
    m.addConstr(x3 <= 274)
    m.addConstr(15*x4 <= 274)
    m.addConstr(10*x2 + 15*x4 >= 56)
    m.addConstr(11*x1 + 10*x2 >= 65)
    m.addConstr(x3 + 15*x4 >= 40)
    m.addConstr(10*x2 + x3 + 15*x4 >= 44)
    m.addConstr(11*x1 + x3 + 15*x4 >= 44)
    m.addConstr(10*x2 + x3 + 15*x4 >= 34)
    m.addConstr(11*x1 + 10*x2 + x3 >= 34)
    m.addConstr(11*x1 + x3 + 15*x4 >= 34)
    m.addConstr(10*x2 + x3 + 15*x4 >= 57)
    m.addConstr(11*x1 + 10*x2 + x3 >= 57)
    m.addConstr(11*x1 + x3 + 15*x4 >= 57)
    m.addConstr(x3 + 15*x4 <= 250)
    m.addConstr(11*x1 + 10*x2 <= 244)
    m.addConstr(10*x2 + x3 <= 151)
    m.addConstr(11*x1 + 10*x2 + x3 + 15*x4 <= 151)

    # Optimize the model
    m.optimize()

    # Print the solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("Hours worked by Ringo: ", x1.varValue)
        print("Hours worked by Bobby: ", x2.varValue)
        print("Hours worked by George: ", x3.varValue)
        print("Hours worked by Laura: ", x4.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
