
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
tomatoes = m.addVar(vtype=gp.GRB.INTEGER, name="tomatoes")
apple_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="apple_pies")
rotisserie_chickens = m.addVar(vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")

# Set objective function
m.setObjective(2 * tomatoes + 3 * apple_pies + 6 * rotisserie_chickens, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * apple_pies + 11 * rotisserie_chickens >= 26)
m.addConstr(17 * tomatoes + 17 * apple_pies + 11 * rotisserie_chickens >= 26)
m.addConstr(18 * tomatoes + 11 * apple_pies >= 41)
m.addConstr(18 * tomatoes + 10 * rotisserie_chickens >= 49)
m.addConstr(18 * tomatoes + 11 * apple_pies + 10 * rotisserie_chickens >= 49)
m.addConstr(1 * tomatoes + 1 * apple_pies >= 17)
m.addConstr(1 * tomatoes + 19 * rotisserie_chickens >= 32)
m.addConstr(1 * tomatoes + 1 * apple_pies + 19 * rotisserie_chickens >= 32)
m.addConstr(18 * tomatoes + 17 * apple_pies >= 50)
m.addConstr(17 * apple_pies + 15 * rotisserie_chickens >= 67)
m.addConstr(18 * tomatoes + 17 * apple_pies + 15 * rotisserie_chickens >= 67)
m.addConstr(-1 * tomatoes + 9 * apple_pies >= 0)
m.addConstr(-1 * apple_pies + 1 * rotisserie_chickens >= 0)
m.addConstr(17 * apple_pies + 11 * rotisserie_chickens <= 159)
m.addConstr(17 * tomatoes + 17 * apple_pies + 11 * rotisserie_chickens <= 160)
m.addConstr(18 * tomatoes + 15 * rotisserie_chickens <= 89)

# Resource Constraints
m.addConstr(17 * tomatoes <= 217)
m.addConstr(18 * tomatoes <= 147)
m.addConstr(1 * tomatoes <= 135)
m.addConstr(18 * tomatoes <= 255)
m.addConstr(17 * apple_pies <= 217)
m.addConstr(11 * apple_pies <= 147)
m.addConstr(1 * apple_pies <= 135)
m.addConstr(17 * apple_pies <= 255)
m.addConstr(11 * rotisserie_chickens <= 217)
m.addConstr(10 * rotisserie_chickens <= 147)
m.addConstr(19 * rotisserie_chickens <= 135)
m.addConstr(15 * rotisserie_chickens <= 255)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('tomatoes:', tomatoes.x)
    print('apple_pies:', apple_pies.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('The problem could not be solved to optimality.')

