
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="tomatoes", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="apple_pies", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(2*x0 + 3*x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17*x1 + 11*x2 >= 26)
    model.addConstr(18*x0 + 11*x1 >= 41)
    model.addConstr(18*x0 + 10*x2 >= 49)
    model.addConstr(18*x0 + 11*x1 + 10*x2 >= 49)
    model.addConstr(x0 + x1 >= 17)
    model.addConstr(x0 + 19*x2 >= 32)
    model.addConstr(x0 + x1 + 19*x2 >= 32)
    model.addConstr(18*x0 + 17*x1 >= 50)
    model.addConstr(17*x1 + 15*x2 >= 67)
    model.addConstr(18*x0 + 17*x1 + 15*x2 >= 67)
    model.addConstr(-x0 + 9*x1 >= 0)
    model.addConstr(-x1 + x2 >= 0)
    model.addConstr(17*x1 + 11*x2 <= 159)
    model.addConstr(17*x0 + 17*x1 + 11*x2 <= 160)
    model.addConstr(18*x0 + 15*x2 <= 89)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Tomatoes: {x0.varValue}")
        print(f"Apple pies: {x1.varValue}")
        print(f"Rotisserie chickens: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
